package com.blogspot.m3g4h4rd.wicket;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;

/**
 * Sets the default focus on a given field, but only the first time when the element is
 * used to render. This means that each time a post back of a result is done, 
 * the focus is not set again. This has the advantage that a post back does not
 * cause again a setting of a 
 * 
 * @author Silvio Meier
 * 
 */
public class DefaultFocusBehavior extends AbstractBehavior {
	/**
	 * The component which gets the default focus behavior.
	 */
	private Component component;

	/**
	 * The render count is used to trace how many times a component was rendered.
	 * Only the first time, i.e. with count == 0, the focus is set.
	 */
	private int renderCount = 0;

	/**
	 * The component to bind to.
	 */
	public void bind(Component component) {
		this.component = component;
		component.setOutputMarkupId(true);
	}

	/**
	 * Renders the java script for the default focus.
	 */
	public void renderHead(IHeaderResponse iHeaderResponse) {
		super.renderHead(iHeaderResponse);

		// causes only the first time the setting of the focus
		iHeaderResponse.renderOnLoadJavascript("if (" + renderCount
				+ "==0) document.getElementById('" + component.getMarkupId()
				+ "').focus();");
		renderCount++;
	}
}
